/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.payloads;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.analysis.TokenFilter;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.payloads.PayloadHelper;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class NumericPayloadTokenFilter
extends TokenFilter {
    private final String typeMatch;
    private final BytesRef thePayload;
    private final PayloadAttribute payloadAtt = this.addAttribute(PayloadAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public NumericPayloadTokenFilter(TokenStream input, float payload, String typeMatch) {
        super(input);
        this.typeMatch = Objects.requireNonNull(typeMatch, "typeMatch");
        this.thePayload = new BytesRef(PayloadHelper.encodeFloat(payload));
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.typeAtt.type().equals(this.typeMatch)) {
                this.payloadAtt.setPayload(this.thePayload);
            }
            return true;
        }
        return false;
    }
}

